from typing import List

class Greetable:
    def greet(self):
        pass

class Person(Greetable):
    def __init__(self, name: str, age: int):
        self.name = name
        self.age = age
    
    def greet(self):
        print(f"Hello, my name is {self.name} and I am {self.age} years old.")

class Greeter:
    def __init__(self, people: List[Person]):
        self.people = people
    
    def greet_everyone(self):
        for person in self.people:
            person.greet()

person1 = Person("Alice", 30)
person2 = Person("Bob", 25)
greeter = Greeter([person1, person2])
greeter.greet_everyone()
